<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class TCRRB_Helpers {
    public static function css_to_xpath( $css ){
        $css = trim($css); if(!$css) return '//*';
        $parts = preg_split('/\s+/', $css); $pieces = array();
        foreach($parts as $p){
            $tag='*'; $conds=array();
            if(preg_match('/#([A-Za-z0-9\-_]+)/',$p,$m)){ $conds[]="@id='{$m[1]}'"; $p=preg_replace('/#([A-Za-z0-9\-_]+)/','',$p); }
            if(preg_match_all('/\.([A-Za-z0-9\-_]+)/',$p,$mm)){ foreach($mm[1] as $c){ $conds[]="contains(concat(' ', normalize-space(@class), ' '), ' {$c} ')"; } $p=preg_replace('/(\.[A-Za-z0-9\-_]+)/','',$p); }
            if(preg_match('/^[A-Za-z0-9\*]+$/',$p)) $tag=$p;
            $seg='//'.$tag; if($conds) $seg.='['.implode(' and ',$conds).']'; $pieces[]=$seg;
        }
        $xp=implode('',$pieces); if($xp==='') $xp='//*'; return $xp;
    }
    public static function clean_html($html){
        $html=preg_replace('#<script[^>]*>.*?</script>#is','',$html);
        $html=preg_replace('#<style[^>]*>.*?</style>#is','',$html);
        $html=preg_replace('#<iframe[^>]*>.*?</iframe>#is','',$html);
        return $html;
    }
    public static function sanitize_urls_textarea($raw){
        $lines=preg_split('/\r\n|\r|\n/', (string)$raw); $urls=array();
        foreach($lines as $l){ $u=trim($l); if($u && filter_var($u, FILTER_VALIDATE_URL)) $urls[]=esc_url_raw($u); }
        return array_unique($urls);
    }
    public static function parse_pipe($raw){
        $out=array(); foreach(preg_split('/\r\n|\r|\n|\|/',$raw) as $v){ $v=trim(wp_strip_all_tags($v)); if($v!=='') $out[]=$v; }
        return $out;
    }
    public static function spintax($text,$seed=null){
        if ($text==='') return $text;
        if ($seed!==null) mt_srand($seed);
        $out = preg_replace_callback('/\{([^{}]+)\}/', function($m){
            $parts = array_values(array_filter(array_map('trim', explode('|',$m[1])), 'strlen'));
            if (empty($parts)) return $m[0];
            return $parts[array_rand($parts)];
        }, $text);
        if ($seed!==null) mt_srand();
        return $out;
    }
    public static function get_setting($key,$default=''){ $opts=get_option('tcrrb_settings', array()); return isset($opts[$key])?$opts[$key]:$default; }
    public static function get_presets(){ $p=get_option('tcrrb_presets', array()); return is_array($p)?$p:array(); }
    public static function save_preset($name,$data){ $p=self::get_presets(); $p[$name]=$data; update_option('tcrrb_presets',$p); return true; }
    public static function queue_get(){ $q=get_option('tcrrb_queue', array()); return is_array($q)?$q:array(); }
    public static function queue_set($q){ update_option('tcrrb_queue',$q); }
}
