<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class TCRRB_Scraper {
    public static function allowed_by_robots( $url, $ua='TCRRB/1.5.2' ){
        $p = wp_parse_url($url); if (empty($p['scheme']) || empty($p['host'])) return false;
        $robots = $p['scheme'].'://'.$p['host'].'/robots.txt';
        $r = wp_remote_get($robots, array('timeout'=>10,'user-agent'=>$ua));
        if (is_wp_error($r)) return true; $body = wp_remote_retrieve_body($r); if (!$body) return true;
        $path = isset($p['path']) ? $p['path'] : '/'; $active=false; $blocked=false;
        foreach (preg_split('/\r\n|\r|\n/',$body) as $line){
            $line = trim($line); if ($line==='' || strpos($line,'#')===0) continue;
            if (stripos($line,'User-agent:')===0){ $uaVal = trim(substr($line,strlen('User-agent:'))); $active = ($uaVal==='*'); }
            elseif ($active && stripos($line,'Disallow:')===0){ $rule = trim(substr($line,strlen('Disallow:'))); if ($rule!=='' && strpos($path,$rule)===0) $blocked=true; }
            elseif ($active && stripos($line,'Allow:')===0){ $rule = trim(substr($line,strlen('Allow:'))); if ($rule!=='' && strpos($path,$rule)===0) $blocked=false; }
        }
        return ! $blocked;
    }
    public static function fetch_xpath( $url, $ua='TCRRB/1.5.2', $timeout=20 ){
        $r = wp_remote_get($url, array('timeout'=>$timeout,'user-agent'=>$ua));
        if (is_wp_error($r)) return false; $code = wp_remote_retrieve_response_code($r); if ($code<200 || $code>=300) return false;
        $html = wp_remote_retrieve_body($r); if (!$html) return false; libxml_use_internal_errors(true);
        $dom = new DOMDocument(); @$dom->loadHTML('<?xml encoding="utf-8" ?>'.$html); libxml_clear_errors(); return new DOMXPath($dom);
    }
    public static function extract( $xp, $selector, $mode='css', $attr='' ){
        if (!$xp || !$selector) return ''; if ($mode==='css') $selector = TCRRB_Helpers::css_to_xpath($selector);
        $nodes = @$xp->query($selector); if (!$nodes || $nodes->length===0) return ''; $out='';
        foreach ($nodes as $n){ $v = $attr ? $n->getAttribute($attr) : $n->C14N(); if ($v) $out .= $v."\n"; } return trim($out);
    }
}
