<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class TCRRB_Schema {
    public static function build_localbusiness($post_id){
        $meta = get_post_meta($post_id,'tcrrb_schema_local',true); if (!is_array($meta)) $meta=array();
        $name=$meta['name'] ?? get_bloginfo('name'); $tel=$meta['telephone'] ?? ''; $url=$meta['url'] ?? get_permalink($post_id); $logo=$meta['logo'] ?? '';
        $area=isset($meta['areaServed'])?(array)$meta['areaServed']:array(); $addr=$meta['address'] ?? array(); $geo=$meta['geo'] ?? array();
        $obj=array("@context"=>"https://schema.org","@type"=>"LocalBusiness","@id"=>$url."#localbusiness","name"=>$name,"url"=>$url);
        if($tel) $obj["telephone"]=$tel; if($logo) $obj["logo"]=$logo; if($area) $obj["areaServed"]=$area; if($addr) $obj["address"]=$addr; if($geo) $obj["geo"]=$geo;
        return '<script type="application/ld+json">'.wp_json_encode($obj).'</script>';
    }
    public static function print_head(){
        if (!is_singular()) return; global $post; if (!$post) return;
        $enabled = get_post_meta($post->ID,'tcrrb_schema_enable',true); if ($enabled) echo self::build_localbusiness($post->ID);
        if (!defined('WPSEO_VERSION') && !defined('RANK_MATH_VERSION')){ $title=get_post_meta($post->ID,'tcrrb_meta_title',true); $desc=get_post_meta($post->ID,'tcrrb_meta_desc',true);
            if ($title) echo '<title>'.esc_html($title).'</title>'."\n"; if ($desc) echo '<meta name=\"description\" content=\"'.esc_attr($desc).'\">'."\n"; }
        $opts=get_option('tcrrb_settings', array());
        if (!empty($opts['sticky_cta'])){ $wa=$opts['whatsapp'] ?? ''; $call=$opts['call'] ?? '';
            if ($wa || $call){ echo '<style>@media(max-width:768px){.tcrrb-sticky-cta{position:fixed;bottom:0;left:0;right:0;z-index:9999;background:#111;color:#fff;padding:10px 12px;display:flex;gap:8px;justify-content:center}.tcrrb-sticky-cta a{background:#fff;color:#111;padding:10px 14px;border-radius:12px;text-decoration:none;font-weight:600;border:1px solid #fff}}</style>';
                echo '<div class="tcrrb-sticky-cta">'; if ($wa) echo '<a href="https://wa.me/'.esc_attr(preg_replace('/[^0-9]/','',$wa)).'" target="_blank" rel="nofollow noopener">WhatsApp</a>'; if ($call) echo '<a href="tel:'.esc_attr($call).'">Llamar</a>'; echo '</div>'; }
        }
    }
}
add_action('wp_head', array('TCRRB_Schema','print_head'), 5);
