<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class TCRRB_Rewriter {
    public static function rewrite($text,$keywords=array()){
        $mode = TCRRB_Helpers::get_setting('rewrite_mode','off'); if ($mode==='off') return $text;
        if ($mode==='spintax') return TCRRB_Helpers::spintax($text);
        if ($mode==='api'){
            $api = TCRRB_Helpers::get_setting('api_endpoint',''); $key = TCRRB_Helpers::get_setting('api_key',''); if (!$api || !$key) return $text;
            $prompt = "Reescribe el texto para SEO local, evita plagio, integra keywords de forma natural. Devuelve HTML (cuerpo limpio).\n\nTexto:\n".$text;
            $req = array('timeout'=>50,'headers'=>array('Content-Type'=>'application/json','Authorization'=>'Bearer '.$key),'body'=>wp_json_encode(array('input'=>$prompt)));
            $res = wp_remote_post($api,$req); if (is_wp_error($res)) return $text; $body=json_decode(wp_remote_retrieve_body($res),true);
            if (isset($body['output'])) return (string)$body['output']; if (isset($body['choices'][0]['message']['content'])) return (string)$body['choices'][0]['message']['content'];
        }
        return $text;
    }
    public static function generate_from_keywords($keywords_line,$h2s=array(),$h3s=array()){
        $keywords = array_map('trim', explode(',', $keywords_line));
        $mode = TCRRB_Helpers::get_setting('rewrite_mode','off');
        if ($mode==='api'){
            $api = TCRRB_Helpers::get_setting('api_endpoint',''); $key = TCRRB_Helpers::get_setting('api_key','');
            if ($api && $key){
                $prompt = "Genera una landing de SEO local (HTML limpio, CTA-friendly). Integra keywords: ".implode(', ',$keywords).". Usa H2/H3 si se proporcionan. Devuelve solo el cuerpo HTML.";
                $req = array('timeout'=>60,'headers'=>array('Content-Type'=>'application/json','Authorization'=>'Bearer '.$key),'body'=>wp_json_encode(array('input'=>$prompt)));
                $res = wp_remote_post($api,$req); if (!is_wp_error($res)){ $body=json_decode(wp_remote_retrieve_body($res),true);
                    if (isset($body['output'])) return (string)$body['output']; if (isset($body['choices'][0]['message']['content'])) return (string)$body['choices'][0]['message']['content']; }
            }
        }
        $html='<p>'.esc_html(implode(' · ',$keywords)).'</p>';
        foreach($h2s as $h2){ $html.='<h2>'.esc_html($h2).'</h2><p>Servicios relacionados con '.esc_html($h2).'.</p>'; }
        foreach($h3s as $h3){ $html.='<h3>'.esc_html($h3).'</h3><ul><li>'.esc_html($h3).' - calidad</li><li>'.esc_html($h3).' - precio</li><li>'.esc_html($h3).' - disponibilidad</li></ul>'; }
        $html.='<p>Solicita presupuesto ahora.</p>'; return $html;
    }
}
