<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class TCRRB_Queue {
    public static function init(){
        add_action('tcrrb_cron_runner', array(__CLASS__,'run_batch'));
        add_action('init', function(){
            $opts = get_option('tcrrb_settings', array());
            if (!empty($opts['cron_enabled'])){
                if (!wp_next_scheduled('tcrrb_cron_runner')){ wp_schedule_event( time()+120, 'hourly', 'tcrrb_cron_runner' ); }
            } else {
                $ts = wp_next_scheduled('tcrrb_cron_runner'); if ($ts) wp_unschedule_event($ts, 'tcrrb_cron_runner');
            }
        });
    }
    public static function enqueue_items($items){
        $q = TCRRB_Helpers::queue_get(); foreach($items as $it){ $q[]=$it; } TCRRB_Helpers::queue_set($q); return count($items);
    }
    public static function run_batch(){
        $opts = get_option('tcrrb_settings', array()); $batch = isset($opts['cron_batch'])?max(1,intval($opts['cron_batch'])):25;
        $delay = isset($opts['delay'])?intval($opts['delay']):900; $q=TCRRB_Helpers::queue_get(); if (empty($q)) return;
        $processed=0; $left=array(); foreach($q as $job){ if($processed>=$batch){ $left[]=$job; continue; } self::process_job($job); $processed++; if($delay) usleep($delay*1000); }
        TCRRB_Helpers::queue_set($left);
    }
    private static function process_job($job){
        $a=$job['args']; $mode=$job['mode']; $payload=$job['payload'];
        $seed=absint(crc32(is_string($payload)?$payload:json_encode($payload)));
        if ($mode==='manual'){
            $row = is_array($payload) ? $payload : json_decode($payload, true);
            if (!$row || empty($row['body_html'])) return;
            $content = $row['body_html'];
            if (!empty($row['allow_spintax'])) $content = TCRRB_Helpers::spintax($content,$seed);
            if (!empty($row['wrap_template'])){
                $tpl = TCRRB_Helpers::spintax($a['template'],$seed);
                $cta = TCRRB_Meta::build_cta_buttons_html();
                $links_html = '';
                if (!empty($row['interlinks'])){
                    $items=array_map('trim', explode(',',$row['interlinks']));
                    if($items){ $links_html.='<div class="tcrrb-links"><ul>'; foreach($items as $lk){
                        if(is_numeric($lk)){ $per=get_permalink(intval($lk)); if($per) $links_html.='<li><a href="'.esc_url($per).'">'.esc_html(get_the_title(intval($lk))).'</a></li>'; }
                        else { $title=get_the_title(url_to_postid($lk))?:$lk; $links_html.='<li><a href="'.esc_url($lk).'">'.esc_html($title).'</a></li>'; }
                    } $links_html.='</ul></div>'; }
                }
                $content = str_replace(array('{H1}','{CONTENT}','{FEATURE_COLUMNS}','{INTERLINKS}','{CTA_TOP}','{CTA_BOTTOM}'),
                                       array(esc_html($row['h1'] ?? 'Página'), $content, '', $links_html,
                                             (isset($row['inject_cta']) and ($row['inject_cta']=='top' or $row['inject_cta']=='both')) ? $cta : '',
                                             (isset($row['inject_cta']) and ($row['inject_cta']=='bottom' or $row['inject_cta']=='both')) ? $cta : ''),
                                       $tpl);
            }
            $postarr = array(
                'post_type'=> $a['post_type'],
                'post_status'=> !empty($row['status']) ? sanitize_key($row['status']) : $a['status'],
                'post_title'=> wp_strip_all_tags($row['h1'] ?? 'Página'),
                'post_content'=> $content,
                'post_author'=> !empty($row['author']) ? intval($row['author']) : ($a['author']?:get_current_user_id()),
                'post_parent'=> !empty($row['parent']) ? intval($row['parent']) : $a['parent'],
            );
            if (!empty($row['slug'])) $postarr['post_name'] = sanitize_title($row['slug']);
            $pid=wp_insert_post(wp_slash($postarr), true); if(is_wp_error($pid)) return;
            $title = !empty($row['meta_title']) ? $row['meta_title'] : ($a['meta_title'] ?: $postarr['post_title']);
            $desc  = !empty($row['meta_desc'])  ? $row['meta_desc']  : ($a['meta_desc'] ?: '');
            TCRRB_Meta::apply_seo_meta($pid, $title, $desc);
            if (!empty($row['schema_enable'])){
                update_post_meta($pid,'tcrrb_schema_enable',1);
                $sch = array(
                    'name'=>$row['schema_name'] ?? '',
                    'telephone'=>$row['schema_tel'] ?? '',
                    'logo'=>$row['schema_logo'] ?? '',
                    'url'=>get_permalink($pid),
                    'areaServed'=> isset($row['schema_area']) ? array_map('trim', explode(',',$row['schema_area'])) : array(),
                    'address'=> !empty($row['schema_addr']) ? json_decode($row['schema_addr'], true) : array(),
                    'geo'=> !empty($row['schema_geo']) ? json_decode($row['schema_geo'], true) : array(),
                );
                update_post_meta($pid,'tcrrb_schema_local',$sch);
            }
            return;
        }
    }
}
