(function($){
  function switchTab(id){ $('.tcrrb-tab').removeClass('active'); $(id).addClass('active'); $('.nav-tab').removeClass('nav-tab-active'); $('.nav-tab[href="'+id+'"]').addClass('nav-tab-active'); }
  $('.nav-tab').on('click', function(e){ e.preventDefault(); switchTab($(this).attr('href')); });

  function crcTable(){
    if (!window.__tcrrb_crc_table){
      let c, table = [];
      for (let n=0;n<256;n++){ c=n; for(let k=0;k<8;k++){ c=((c&1)?(0xEDB88320^(c>>>1)):(c>>>1))>>>0; } table[n]=c>>>0; }
      window.__tcrrb_crc_table = table;
    }
    return window.__tcrrb_crc_table;
  }
  function tcrrb_crc32(str){
    const tbl = crcTable(); let crc = 0 ^ (-1);
    for (let i=0;i<str.length;i++){ const code=str.charCodeAt(i); const idx=(crc ^ code) & 0xFF; crc=((crc>>>8) ^ tbl[idx])>>>0; }
    crc = (crc ^ (-1))>>>0; return crc>>>0;
  }
  function modeVal(){ return $('input[name="tcrrb_mode_selector"]:checked').val(); }
  function recalcSeed(){
    const mode = modeVal();
    const h1 = $('#tcrrb_h1').val().trim();
    let payload = 'payload';
    if (mode==='csv' || mode==='manual'){
      const csv = ($('#tcrrb_csv').val()||'').split(/\r?\n/);
      payload = csv[1] || h1 || payload;
    } else if (mode==='fullauto'){
      const lines = ($('#tcrrb_keywords_lines').val()||'').split(/\r?\n/).map(s=>s.trim()).filter(Boolean);
      payload = lines[0] || h1 || payload;
    } else {
      const urls = ($('#tcrrb_urls').val()||'').split(/\r?\n/).map(s=>s.trim()).filter(s=>/^https?:\/\//i.test(s));
      payload = urls[0] || h1 || payload;
    }
    $('#tcrrb_seed').val( String(tcrrb_crc32(payload)) );
  }
  function toggleMode(){
    const m = modeVal();
    $('.row-csv,.row-scrape,.row-fullauto,.row-manual,.row-nonmanual').hide();
    if (m==='csv') $('.row-csv,.row-nonmanual').show();
    if (m==='manual') $('.row-manual').show();
    if (m==='scrape') $('.row-scrape,.row-nonmanual').show();
    if (m==='fullauto') $('.row-fullauto,.row-nonmanual').show();
    recalcSeed();
  }
  $('input[name="tcrrb_mode_selector"]').on('change', toggleMode);
  $('#tcrrb_h1,#tcrrb_csv,#tcrrb_keywords_lines,#tcrrb_urls').on('input', recalcSeed);
  $('#tcrrb_btn_seed').on('click', function(e){ e.preventDefault(); recalcSeed(); });
  $('#tcrrb_btn_seed_srv').on('click', function(e){
    e.preventDefault();
    const data = gather();
    $.post(TCRRB.ajax, Object.assign({action:'tcrrb_calc_seed_server',nonce:TCRRB.nonce}, data), function(resp){
      alert(resp && resp.success ? ('Seed servidor: '+resp.data.seed) : 'Error servidor');
    });
  });
  function gather(){
    return {
      mode_selector: $('input[name="tcrrb_mode_selector"]:checked').val(),
      csv: $('#tcrrb_csv').val(),
      urls: $('#tcrrb_urls').val(),
      sel_body: $('#tcrrb_sel_body').val(),
      mode: $('#tcrrb_mode').val(),
      keywords_lines: $('#tcrrb_keywords_lines').val(),
      keywords: $('#tcrrb_keywords').val(),
      h1: $('#tcrrb_h1').val(),
      h2: $('#tcrrb_h2').val(),
      h3: $('#tcrrb_h3').val(),
      images: $('#tcrrb_images').val(),
      columns: $('#tcrrb_columns').val(),
      template: $('#tcrrb_template').val(),
      meta_title: $('#tcrrb_meta_title').val(),
      meta_desc: $('#tcrrb_meta_desc').val(),
      schema_enable: $('#tcrrb_schema_enable').is(':checked')?1:0,
      schema_name: $('#tcrrb_schema_name').val(),
      schema_tel: $('#tcrrb_schema_tel').val(),
      schema_logo: $('#tcrrb_schema_logo').val(),
      schema_area: $('#tcrrb_schema_area').val(),
      schema_addr: $('#tcrrb_schema_addr').val(),
      schema_geo: $('#tcrrb_schema_geo').val(),
      links: $('#tcrrb_links').val(),
      post_type: $('#tcrrb_post_type').val(),
      status: $('#tcrrb_status').val(),
      author: $('#tcrrb_author').val(),
      parent: $('#tcrrb_parent').val(),
      delay: $('#tcrrb_delay').val(),
      max: $('#tcrrb_max').val()
    };
  }
  function post(action, extra, cb){
    const data = Object.assign({action: action, nonce: TCRRB.nonce}, gather(), extra||{});
    $.post(TCRRB.ajax, data, cb);
  }
  $('#tcrrb_btn_dry').on('click', function(e){
    e.preventDefault();
    $('#tcrrb_result').html('<p>Simulando...</p>');
    post('tcrrb_dry_run', {}, function(resp){
      if(!resp || !resp.success){ $('#tcrrb_result').html('<div class="notice notice-error"><p>'+ (resp?.data?.message || 'Error en simulación') +'</p></div>'); return; }
      const s = resp.data.summary;
      let html = '<div class="notice notice-info"><p><strong>DRY RUN</strong></p>';
      html += '<p>Modo: <code>'+s.mode+'</code></p>';
      html += '<p>Detectadas: <strong>'+s.count+'</strong> páginas</p>';
      if (s.fields && s.fields.length){ html += '<p>CSV campos: '+s.fields.join(', ')+'</p>'; }
      if (s.errors && s.errors.length){ html += '<p>Observaciones: '+s.errors.join(' | ')+'</p>'; }
      html += '<p>Seed (estimada): <code>'+s.seed+'</code></p>';
      html += '</div>';
      $('#tcrrb_result').html(html);
    });
  });
  $('#tcrrb_btn_preview').on('click', function(e){
    e.preventDefault();
    $('#tcrrb_result').html('<p>Generando previsualización...</p>');
    post('tcrrb_preview', {}, function(resp){
      if(!resp || !resp.success){ $('#tcrrb_result').html('<div class="notice notice-error"><p>'+ (resp?.data?.message || 'Error') +'</p></div>'); return; }
      $('#tcrrb_result').html('<div class="notice notice-success"><p><strong>Preview</strong></p><div class="code" style="white-space:pre-wrap;border:1px solid #e5e7eb;padding:10px;border-radius:8px;max-height:420px;overflow:auto;">'+ resp.data.preview +'</div></div>');
    });
  });
  $('#tcrrb_btn_generate').on('click', function(e){
    e.preventDefault();
    $('#tcrrb_result').html('<p>Creando páginas...</p>');
    post('tcrrb_generate', {}, function(resp){
      if(!resp || !resp.success){ $('#tcrrb_result').html('<div class="notice notice-error"><p>'+ (resp?.data?.message || 'Error') +'</p></div>'); return; }
      let html = '<div class="notice notice-success"><p>Generadas: <strong>'+resp.data.created+'</strong></p></div>';
      if(resp.data.errors && resp.data.errors.length){
        html += '<div class="notice notice-warning"><ul>';
        resp.data.errors.forEach(function(e){ html += '<li>'+e+'</li>'; });
        html += '</ul></div>';
      }
      $('#tcrrb_result').html(html);
    });
  });
  $('#tcrrb_btn_enqueue').on('click', function(e){
    e.preventDefault();
    post('tcrrb_enqueue', {}, function(resp){
      if(!resp || !resp.success){ $('#tcrrb_result').html('<div class="notice notice-error"><p>'+ (resp?.data?.message || 'Error') +'</p></div>'); return; }
      $('#tcrrb_result').html('<div class="notice notice-success"><p>Encoladas: <strong>'+resp.data.queued+'</strong></p></div>');
      $('.nav-tab[href="#tab-queue"]').trigger('click');
    });
  });
  $('#tcrrb_btn_run_batch').on('click', function(e){
    e.preventDefault();
    $('#tcrrb_queue_msg').html('<p>Ejecutando lote...</p>');
    post('tcrrb_run_batch', {}, function(resp){
      if(!resp || !resp.success){ $('#tcrrb_queue_msg').html('<div class="notice notice-error"><p>'+ (resp?.data?.message || 'Error') +'</p></div>'); return; }
      $('#tcrrb_queue_msg').html('<div class="notice notice-success"><p>Pendientes en cola: <strong>'+resp.data.remaining+'</strong></p></div>');
    });
  });
  $(function(){ switchTab('#tab-generator'); setTimeout(function(){ $('#tcrrb_btn_seed').trigger('click'); }, 120); });
})(jQuery);