<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class TCRRB_Admin {
    public function __construct(){
        add_action('admin_menu', array($this,'menu'));
        add_action('admin_enqueue_scripts', array($this,'assets'));
        add_action('admin_init', array($this,'register_settings'));
        add_action('wp_ajax_tcrrb_preview', array($this,'ajax_preview'));
        add_action('wp_ajax_tcrrb_generate', array($this,'ajax_generate'));
        add_action('wp_ajax_tcrrb_dry_run', array($this,'ajax_dry_run'));
        add_action('wp_ajax_tcrrb_save_preset', array($this,'ajax_save_preset'));
        add_action('wp_ajax_tcrrb_load_preset', array($this,'ajax_load_preset'));
        add_action('wp_ajax_tcrrb_enqueue', array($this,'ajax_enqueue'));
        add_action('wp_ajax_tcrrb_run_batch', array($this,'ajax_run_batch'));
        add_action('wp_ajax_tcrrb_calc_seed_server', array($this,'ajax_calc_seed_server'));
    }
    public function menu(){ add_menu_page('Rank&Rent Builder','Rank&Rent Builder','manage_options','tcrrb', array($this,'render'), 'dashicons-category', 56); }
    public function assets($hook){
        if (strpos($hook,'tcrrb')===false) return;
        wp_enqueue_style('tcrrb-admin', TCRRB_URL.'assets/css/admin.css', array(), TCRRB_VERSION);
        wp_enqueue_script('tcrrb-admin', TCRRB_URL.'assets/js/admin.js', array('jquery'), TCRRB_VERSION, true);
        wp_localize_script('tcrrb-admin','TCRRB', array('ajax'=>admin_url('admin-ajax.php'),'nonce'=>wp_create_nonce('tcrrb_nonce')));
    }
    public function register_settings(){ register_setting('tcrrb_settings_group','tcrrb_settings'); }
    public function render(){ $presets=TCRRB_Helpers::get_presets(); $opts=get_option('tcrrb_settings', array()); ?>
<div class="wrap tcrrb-wrap">
  <h1>TC Rank&Rent Builder (v5.2)</h1>
  <h2 class="nav-tab-wrapper">
    <a href="#tab-generator" class="nav-tab nav-tab-active">Generador</a>
    <a href="#tab-presets" class="nav-tab">Plantillas</a>
    <a href="#tab-queue" class="nav-tab">Cola & Cron</a>
    <a href="#tab-settings" class="nav-tab">Ajustes</a>
    <a href="#tab-help" class="nav-tab">Ayuda / Guía completa</a>
  </h2>
  <div id="tab-generator" class="tcrrb-tab active">
    <h2>Modo</h2>
    <p>
      <label><input type="radio" name="tcrrb_mode_selector" value="csv" /> CSV</label>
      <label style="margin-left:12px"><input type="radio" name="tcrrb_mode_selector" value="manual" /> Manual Passthrough (CSV/HTML)</label>
      <label style="margin-left:12px"><input type="radio" name="tcrrb_mode_selector" value="scrape" checked/> Scraping</label>
      <label style="margin-left:12px"><input type="radio" name="tcrrb_mode_selector" value="fullauto" /> Full Auto (solo keywords)</label>
    </p>
    <table class="form-table">
      <tr class="row-csv row-manual"><th>CSV (pegar contenido)</th><td>
        <textarea id="tcrrb_csv" class="large-text code" rows="6" placeholder="Manual: h1,slug,meta_title,meta_desc,schema_enable,schema_name,schema_tel,schema_logo,schema_area,schema_addr,schema_geo,status,wrap_template,allow_spintax,inject_cta,interlinks,body_html&#10;CSV estándar: h1,keywords,h2,h3,images,columns,meta_title,meta_desc,interlinks,schema_*,status,template"></textarea>
        <p class="description">Pega CSV en UTF-8. Cada fila = 1 página.</p>
      </td></tr>
      <tr class="row-scrape"><th>URLs fuente</th><td><textarea id="tcrrb_urls" class="large-text code" rows="6" placeholder="https://sitio1.com/articulo&#10;https://sitio2.com/post"></textarea></td></tr>
      <tr class="row-scrape"><th>Selectores (CSS/XPath)</th><td>
        <p><label>Cuerpo: <input id="tcrrb_sel_body" class="regular-text" placeholder=".entry-content o //*[@id='content']"/></label>
           <label style="margin-left:10px">Modo: <select id="tcrrb_mode"><option value="css">CSS</option><option value="xpath">XPath</option></select></label>
        </p>
      </td></tr>
      <tr class="row-fullauto"><th>Palabras clave (1 línea = 1 página)</th><td>
        <textarea id="tcrrb_keywords_lines" class="large-text code" rows="6" placeholder="cerrajero madrid, puertas de seguridad&#10;cerrajero barcelona, rejas soldadas"></textarea>
      </td></tr>
      <tr><th>Keywords (coma)</th><td><input id="tcrrb_keywords" class="large-text" placeholder="keyword 1, keyword 2, ..." /></td></tr>
      <tr><th>H1 (fijo, sin spintax)</th><td><input id="tcrrb_h1" class="large-text" placeholder="Servicio + Ciudad/Provincia" /></td></tr>
      <tr><th>Semilla (seed)</th><td><input id="tcrrb_seed" class="regular-text" value="" readonly /><button id="tcrrb_btn_seed_srv" class="button" style="margin-left:8px">Verificar con servidor</button></td></tr>
      <tr class="row-nonmanual"><th>H2 (| y spintax)</th><td><input id="tcrrb_h2" class="large-text" placeholder="{Tipos|Modelos|Estilos|Diseños}|Presupuesto {rápido|express}|Instalación profesional" /></td></tr>
      <tr class="row-nonmanual"><th>H3 (| y spintax)</th><td><input id="tcrrb_h3" class="large-text" placeholder="{Puertas exteriores|Puertas interiores|Rejas|Vallas}|Acabados|Garantías" /></td></tr>
      <tr class="row-nonmanual"><th>Imágenes (URLs, coma)</th><td><input id="tcrrb_images" class="large-text" /></td></tr>
      <tr class="row-nonmanual"><th>Columnas (img|h3|texto; spintax OK)</th><td><textarea id="tcrrb_columns" class="large-text code" rows="3"></textarea></td></tr>
      <tr><th>Plantilla (spintax OK)</th><td><textarea id="tcrrb_template" class="large-text code" rows="6"><div class="tcrrb-container">
<h1>{H1}</h1>
{CTA_TOP}
{CONTENT}
{FEATURE_COLUMNS}
{INTERLINKS}
{CTA_BOTTOM}
</div></textarea></td></tr>
      <tr><th>SEO por defecto</th><td>
        <p><label>Título: <input id="tcrrb_meta_title" class="large-text" /></label></p>
        <p><label>Descripción: <input id="tcrrb_meta_desc" class="large-text" /></label></p>
      </td></tr>
      <tr><th>Schema Local (si procede)</th><td>
        <label><input id="tcrrb_schema_enable" type="checkbox" checked/> Activar</label>
        <p><label>Nombre: <input id="tcrrb_schema_name" class="regular-text"/></label>
           <label style="margin-left:10px">Tel&eacute;fono: <input id="tcrrb_schema_tel" class="regular-text"/></label>
           <label style="margin-left:10px">Logo: <input id="tcrrb_schema_logo" class="regular-text"/></label></p>
        <p><label>Áreas (coma): <input id="tcrrb_schema_area" class="large-text"/></label></p>
        <p><label>Address (JSON): <textarea id="tcrrb_schema_addr" class="large-text code" rows="2"></textarea></label></p>
        <p><label>Geo (JSON): <textarea id="tcrrb_schema_geo" class="large-text code" rows="2"></textarea></label></p>
      </td></tr>
      <tr class="row-nonmanual"><th>Interlinking</th><td><input id="tcrrb_links" class="large-text" placeholder="/contacto, /presupuesto"/></td></tr>
      <tr><th>Salida</th><td>
        <label>Tipo <select id="tcrrb_post_type"><option value="page">page</option><option value="post">post</option></select></label>
        <label style="margin-left:10px">Estado <select id="tcrrb_status"><option value="draft">draft</option><option value="publish">publish</option><option value="pending">pending</option></select></label>
        <label style="margin-left:10px">Autor (ID) <input id="tcrrb_author" type="number" value="0" class="small-text"/></label>
        <label style="margin-left:10px">Padre (ID) <input id="tcrrb_parent" type="number" value="0" class="small-text"/></label>
        <label style="margin-left:10px">Máx/ejec. <input id="tcrrb_max" type="number" class="small-text" value="20"/></label>
        <label style="margin-left:10px">Retardo (ms) <input id="tcrrb_delay" type="number" class="small-text" value="900"/></label>
      </td></tr>
    </table>
    <p>
      <button id="tcrrb_btn_seed" class="button">Recalcular seed</button>
      <button id="tcrrb_btn_dry" class="button">Simular (Dry Run)</button>
      <button id="tcrrb_btn_preview" class="button">Previsualizar</button>
      <button id="tcrrb_btn_generate" class="button button-primary">Generar ahora</button>
      <button id="tcrrb_btn_enqueue" class="button">Enviar a COLA</button>
    </p>
    <div id="tcrrb_result"></div>
  </div>
  <div id="tab-presets" class="tcrrb-tab">
    <h2>Plantillas guardadas</h2>
    <p><label>Nombre: <input id="tcrrb_preset_name" class="regular-text"/></label>
       <button id="tcrrb_btn_save_preset" class="button">Guardar</button></p>
    <p><label>Cargar: <select id="tcrrb_preset_select"><option value="">—</option><?php foreach($presets as $n=>$d){ echo '<option value="'.esc_attr($n).'">'.esc_html($n).'</option>'; } ?></select></label>
       <button id="tcrrb_btn_load_preset" class="button">Cargar en Generador</button></p>
    <div id="tcrrb_preset_msg"></div>
  </div>
  <div id="tab-queue" class="tcrrb-tab">
    <h2>Cola & Cron</h2>
    <form method="post" action="options.php">
      <?php settings_fields('tcrrb_settings_group'); $opts=get_option('tcrrb_settings', array()); ?>
      <p><label><input type="checkbox" name="tcrrb_settings[cron_enabled]" <?php checked(!empty($opts['cron_enabled'])); ?>/> Activar cron (cada hora)</label></p>
      <p><label>Tamaño lote: <input type="number" name="tcrrb_settings[cron_batch]" value="<?php echo esc_attr($opts['cron_batch'] ?? 25); ?>" class="small-text"/> páginas/hora</label></p>
      <?php submit_button('Guardar'); ?>
    </form>
    <p><button id="tcrrb_btn_run_batch" class="button">Ejecutar 1 lote ahora</button></p>
    <div id="tcrrb_queue_msg"></div>
  </div>
  <div id="tab-settings" class="tcrrb-tab">
    <form method="post" action="options.php">
      <?php settings_fields('tcrrb_settings_group'); $opts=get_option('tcrrb_settings', array()); ?>
      <h2>Ajustes</h2>
      <p><label>Reescritura:
        <select name="tcrrb_settings[rewrite_mode]">
          <?php $m=$opts['rewrite_mode']??'spintax'; ?>
          <option value="off" <?php selected($m,'off'); ?>>Apagado</option>
          <option value="spintax" <?php selected($m,'spintax'); ?>>Spintax</option>
          <option value="api" <?php selected($m,'api'); ?>>API externa</option>
        </select></label></p>
      <p><label><input type="checkbox" name="tcrrb_settings[spintax_variation]" <?php checked(!empty($opts['spintax_variation'])); ?>/> Activar variación por spintax (H1 no)</label></p>
      <p><label>Endpoint API: <input name="tcrrb_settings[api_endpoint]" class="large-text" value="<?php echo esc_attr($opts['api_endpoint'] ?? ''); ?>"/></label></p>
      <p><label>API Key: <input name="tcrrb_settings[api_key]" class="large-text" value="<?php echo esc_attr($opts['api_key'] ?? ''); ?>"/></label></p>
      <h3>CTA</h3>
      <p><label>WhatsApp: <input name="tcrrb_settings[whatsapp]" class="regular-text" value="<?php echo esc_attr($opts['whatsapp'] ?? ''); ?>"/></label>
         <label style="margin-left:10px">Teléfono: <input name="tcrrb_settings[call]" class="regular-text" value="<?php echo esc_attr($opts['call'] ?? ''); ?>"/></label></p>
      <p><label>Formulario (shortcode): <input name="tcrrb_settings[form_shortcode]" class="large-text" value="<?php echo esc_attr($opts['form_shortcode'] ?? ''); ?>"/></label></p>
      <p><label><input type="checkbox" name="tcrrb_settings[sticky_cta]" <?php checked(!empty($opts['sticky_cta'])); ?>/> Sticky CTA móvil</label></p>
      <?php submit_button('Guardar ajustes'); ?>
    </form>
  </div>
  <div id="tab-help" class="tcrrb-tab">
    <div class="tcrrb-help">
<h2>TC Rank&Rent Builder — Guía de uso profesional</h2>
<p>Este plugin genera páginas en masa en WordPress en cuatro modos: CSV, Manual Passthrough, Scraping y Full Auto. A continuación se documenta cada módulo, formato y buenas prácticas.</p>
<hr/>
<h3>1) Modos de trabajo</h3>
<ul>
<li><strong>CSV estándar</strong>: combina campos de CSV + Plantilla con tokens ({H1},{CONTENT},{CTA_TOP},{INTERLINKS},...). Permite spintax e IA.</li>
<li><strong>Manual Passthrough (CSV/HTML)</strong>: crea páginas exactamente con tu HTML (body_html) sin tocarlo. Opcionalmente puedes envolver con plantilla, interlinks y CTA por fila.</li>
<li><strong>Scraping</strong>: extrae cuerpo desde URLs con selectores CSS/XPath, limpia HTML y reescribe/maqueta según plantilla.</li>
<li><strong>Full Auto</strong>: genera el cuerpo desde keywords usando tu API (Ajustes → Endpoint/Key).</li>
</ul>
<h3>2) Diferencia clave: CSV estándar vs Manual Passthrough</h3>
<table class="widefat striped">
<thead><tr><th>Característica</th><th>CSV estándar</th><th>Manual Passthrough</th></tr></thead>
<tbody>
<tr><td>Objetivo</td><td>Automatizar y variar con plantilla/spintax</td><td>Respetar 100% tu HTML sin modificar</td></tr>
<tr><td>Quién escribe</td><td>El plugin/IA</td><td>Tú (o tu redactor/ChatGPT)</td></tr>
<tr><td>Plantilla</td><td>Necesaria</td><td>Opcional (wrap_template=1)</td></tr>
<tr><td>Spintax</td><td>Sí (global)</td><td>Solo si allow_spintax=1 por fila</td></tr>
<tr><td>Interlinks/CTA</td><td>Automático</td><td>Manual u opcional por fila</td></tr>
</tbody></table>
<h3>3) CSV Manual Passthrough</h3>
<p>Columnas mínimas: <code>h1, body_html</code>. Opcionales: slug, meta_title, meta_desc, status, author, parent, schema_* (JSON), wrap_template (1/0), allow_spintax (1/0), inject_cta (top|bottom|both|none), interlinks.</p>
<h3>4) CSV estándar</h3>
<p>Campos habituales: h1, keywords, h2, h3, images, columns, meta_title, meta_desc, interlinks, schema_*, status, template.</p>
<h3>5) Tokens en Plantilla</h3>
<p>{H1}, {CONTENT}, {FEATURE_COLUMNS}, {INTERLINKS}, {CTA_TOP}, {CTA_BOTTOM}.</p>
<h3>6) Spintax y Semilla</h3>
<p>Spintax: {a|b|c}. Semilla visible (CRC32) para variaciones deterministas. El H1 no se spinta.</p>
<h3>7) Cola & Cron</h3>
<p>Encolar lotes grandes y publicar por horas (p.ej. 25/hora) para reducir carga del servidor.</p>
<h3>8) Ajustes</h3>
<p>Reescritura (off/spintax/api), Endpoint/Key, CTA (WhatsApp, Teléfono, Form), Sticky CTA móvil, Spintax global.</p>
<h3>9) Prompts para generar CSV desde ChatGPT</h3>
<p>Incluye prompts recomendados para: Manual Passthrough y CSV estándar (ver documentación original).</p>
<h3>10) Registro de funciones protegidas</h3>
<p>Todas las funciones presentes desde v5.1 están garantizadas en futuras versiones. Autoría: Tania Caballero – <a href="https://taniacaballero.com" target="_blank" rel="noopener">taniacaballero.com</a>.</p>
</div>
    <p><em>Autor: Tania Caballero — <a href="https://taniacaballero.com" target="_blank" rel="noopener">taniacaballero.com</a></em></p>
  </div>
</div>
<?php }
    // Ajax (Manual Passthrough y utilidades)
    private function collect_args(){
        $a=array();
        $a['mode_selector'] = sanitize_text_field($_POST['mode_selector'] ?? 'scrape');
        $a['csv'] = wp_unslash($_POST['csv'] ?? '');
        $a['urls'] = wp_unslash($_POST['urls'] ?? '');
        $a['sel_body'] = sanitize_text_field($_POST['sel_body'] ?? '');
        $a['mode'] = ($_POST['mode'] ?? 'css')==='xpath' ? 'xpath':'css';
        $a['keywords_lines'] = wp_unslash($_POST['keywords_lines'] ?? '');
        $a['keywords']  = array_map('trim', explode(',', wp_unslash($_POST['keywords'] ?? '')));
        $a['h1'] = wp_unslash($_POST['h1'] ?? '');
        $a['h2'] = wp_unslash($_POST['h2'] ?? '');
        $a['h3'] = wp_unslash($_POST['h3'] ?? '');
        $a['images'] = array_map('trim', explode(',', wp_unslash($_POST['images'] ?? '')));
        $a['columns'] = wp_unslash($_POST['columns'] ?? '');
        $a['template'] = wp_kses_post( wp_unslash($_POST['template'] ?? '') );
        $a['meta_title'] = wp_unslash($_POST['meta_title'] ?? '');
        $a['meta_desc']  = wp_unslash($_POST['meta_desc'] ?? '');
        $a['schema_enable'] = !empty($_POST['schema_enable']);
        $a['schema_name'] = sanitize_text_field($_POST['schema_name'] ?? '');
        $a['schema_tel']  = sanitize_text_field($_POST['schema_tel'] ?? '');
        $a['schema_logo'] = esc_url_raw($_POST['schema_logo'] ?? '');
        $a['schema_area'] = array_map('trim', explode(',', wp_unslash($_POST['schema_area'] ?? '')));
        $a['schema_addr'] = json_decode(wp_unslash($_POST['schema_addr'] ?? ''), true);
        $a['schema_geo']  = json_decode(wp_unslash($_POST['schema_geo'] ?? ''), true);
        $a['links'] = wp_unslash($_POST['links'] ?? '');
        $a['post_type'] = sanitize_key($_POST['post_type'] ?? 'page');
        $a['status'] = sanitize_key($_POST['status'] ?? 'draft');
        $a['author'] = intval($_POST['author'] ?? 0);
        $a['parent'] = intval($_POST['parent'] ?? 0);
        $a['delay'] = intval($_POST['delay'] ?? 900);
        $a['max']   = intval($_POST['max'] ?? 20);
        return $a;
    }
    private function parse_csv_rows($csv){
        $csv = trim($csv); if ($csv==='') return array();
        $lines = preg_split('/\r\n|\r|\n/', $csv);
        $headers = str_getcsv(array_shift($lines));
        $rows = array();
        foreach($lines as $ln){
            if (trim($ln)==='') continue;
            $data = str_getcsv($ln);
            $row = array();
            foreach($headers as $i=>$h){ $row[ trim($h) ] = $data[$i] ?? ''; }
            $rows[] = $row;
        }
        return array($headers, $rows);
    }
    private function payload_seed_source($args){
        $mode = $args['mode_selector'];
        if ($mode==='manual' || $mode==='csv'){
            $csv = trim($args['csv']); if ($csv!==''){ $lines = preg_split('/\r\n|\r|\n/',$csv); return $lines[1] ?? ($args['h1'] ?: 'payload'); }
        } elseif ($mode==='fullauto'){
            $lines = preg_split('/\r\n|\r|\n/', $args['keywords_lines']); foreach($lines as $l){ $l=trim($l); if($l!=='') return $l; }
        } else {
            $urls = TCRRB_Helpers::sanitize_urls_textarea($args['urls']); if ($urls) return $urls[0];
        }
        return $args['h1'] ?: 'payload';
    }
    public function ajax_calc_seed_server(){
        check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado'));
        $a = $this->collect_args(); $payload = $this->payload_seed_source($a); $seed = absint(crc32($payload));
        wp_send_json_success(array('seed'=>$seed));
    }
    public function ajax_dry_run(){
        check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado'));
        $a = $this->collect_args(); $mode=$a['mode_selector']; $summary=array('mode'=>$mode,'count'=>0,'errors'=>array(),'fields'=>array());
        if ($mode==='manual' || $mode==='csv'){
            list($headers,$rows) = $this->parse_csv_rows($a['csv']);
            if (empty($rows)) wp_send_json_error(array('message'=>'CSV vacío o inválido'));
            $summary['count']=count($rows); $summary['fields']=$headers;
            if ($mode==='manual'){
                $missing=0;
                foreach($rows as $r){ if (empty($r['h1']) or empty($r['body_html'])) $missing++; }
                if ($missing>0) $summary['errors'][] = 'Filas sin h1 o body_html: '+$missing;
            }
        } elseif ($mode==='fullauto'){
            $lines = preg_split('/\r\n|\r|\n/', $a['keywords_lines']); $n=0; 
            foreach($lines as $l){ 
                if(trim($l)!=='') $n++; 
            } 
            $summary['count']=$n;
        } else {
            $urls = TCRRB_Helpers::sanitize_urls_textarea($a['urls']); $summary['count']=count($urls);
        }
        $payload = $this->payload_seed_source($a); $summary['seed']=absint(crc32($payload));
        wp_send_json_success(array('summary'=>$summary));
    }
    public function ajax_preview(){
        check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado'));
        $a = $this->collect_args(); $opts=get_option('tcrrb_settings', array()); $spx=!empty($opts['spintax_variation']); $seed=123;
        $h1 = $a['h1'] ?: 'Servicio — Localidad';
        if ($a['mode_selector']==='manual'){
            list($headers,$rows) = $this->parse_csv_rows($a['csv']);
            if (empty($rows)) wp_send_json_error(array('message'=>'CSV manual vacío'));
            $r = $rows[0];
            if (empty($r['h1']) || empty($r['body_html'])) wp_send_json_error(array('message'=>'La primera fila manual necesita h1 y body_html'));
            $content = $r['body_html'];
            if (!empty($r['allow_spintax'])) $content = TCRRB_Helpers::spintax($content,$seed);
            if (!empty($r['wrap_template'])){
                $tpl = TCRRB_Helpers::spintax($a['template'],$seed);
                $cta = TCRRB_Meta::build_cta_buttons_html();
                $links_html = '';
                if (!empty($r['interlinks'])){
                    $items=array_map('trim', explode(',',$r['interlinks']));
                    if($items){ $links_html.='<div class="tcrrb-links"><ul>'; foreach($items as $lk){
                        if(is_numeric($lk)){ $per=get_permalink(intval($lk)); if($per) $links_html.='<li><a href="'.esc_url($per).'">'.esc_html(get_the_title(intval($lk))).'</a></li>'; }
                        else { $title=get_the_title(url_to_postid($lk))?:$lk; $links_html.='<li><a href="'.esc_url($lk).'">'.esc_html($title).'</a></li>'; }
                    } $links_html.='</ul></div>'; }
                }
                $content = str_replace(array('{H1}','{CONTENT}','{FEATURE_COLUMNS}','{INTERLINKS}','{CTA_TOP}','{CTA_BOTTOM}'),
                                       array(esc_html($r['h1']), $content, '', $links_html,
                                             (!empty($r['inject_cta']) and ($r['inject_cta']=='top' or $r['inject_cta']=='both')) ? $cta : '',
                                             (!empty($r['inject_cta']) and ($r['inject_cta']=='bottom' or $r['inject_cta']=='both')) ? $cta : ''),
                                       $tpl);
            }
            wp_send_json_success(array('preview'=>'<div class="tcrrb-container"><h1>'.esc_html($r['h1']).'</h1>'.$content.'</div>'));
        } else {
            $content='';
            if ($a['mode_selector']==='fullauto'){
                $kw_line = ''; 
                foreach(preg_split('/\r\n|\r|\n/',$a['keywords_lines']) as $l){ $l=trim($l); if($l!==''){ $kw_line=$l; break; } }
                $h2s = TCRRB_Helpers::parse_pipe($spx ? TCRRB_Helpers::spintax($a['h2'],$seed) : $a['h2']);
                $h3s = TCRRB_Helpers::parse_pipe($spx ? TCRRB_Helpers::spintax($a['h3'],$seed) : $a['h3']);
                $content = TCRRB_Rewriter::generate_from_keywords($kw_line,$h2s,$h3s);
            } else {
                $urls = TCRRB_Helpers::sanitize_urls_textarea($a['urls']);
                if (!$urls) wp_send_json_error(array('message'=>'Sin URLs válidas para previsualizar'));
                $xp = TCRRB_Scraper::fetch_xpath($urls[0], 'TCRRB/1.5.2'); if(!$xp) wp_send_json_error(array('message'=>'No se pudo descargar'));
                $b_raw = TCRRB_Scraper::extract($xp, $a['sel_body'], $a['mode']);
                $b_raw = TCRRB_Helpers::clean_html($b_raw);
                $content = TCRRB_Rewriter::rewrite($b_raw, $a['keywords']);
            }
            if ($spx) $content = TCRRB_Helpers::spintax($content,$seed);
            wp_send_json_success(array('preview'=>'<div class="tcrrb-container"><h1>'.esc_html($h1).'</h1>'.$content.'</div>'));
        }
    }
    public function ajax_generate(){
        check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado'));
        $a = $this->collect_args(); $created=0; $errors=array(); $count=0;
        $mode = $a['mode_selector'];
        if ($mode==='manual'){
            list($headers,$rows) = $this->parse_csv_rows($a['csv']);
            if (empty($rows)) wp_send_json_error(array('message'=>'CSV manual vacío'));
            for($i=0;$i<count($rows);$i++){
                if ($count >= $a['max']) break; $count++;
                $r = $rows[$i]; if (empty($r['h1']) or empty($r['body_html'])){ $errors.append('Fila '+($i+2)+': sin h1/body_html'); continue; }
                $seed = absint(crc32(json_encode($r)));
                $content = $r['body_html'];
                if (!empty($r['allow_spintax'])) $content = TCRRB_Helpers::spintax($content,$seed);
                if (!empty($r['wrap_template'])){
                    $tpl = TCRRB_Helpers::spintax($a['template'],$seed);
                    $cta = TCRRB_Meta::build_cta_buttons_html();
                    $links_html = '';
                    if (!empty($r['interlinks'])){
                        $items=array_map('trim', explode(',',$r['interlinks']));
                        if($items){ $links_html.='<div class="tcrrb-links"><ul>'; foreach($items as $lk){
                            if(is_numeric($lk)){ $per=get_permalink(intval($lk)); if($per) $links_html.='<li><a href="'.esc_url($per).'">'.esc_html(get_the_title(intval($lk))).'</a></li>'; }
                            else { $title=get_the_title(url_to_postid($lk))?:$lk; $links_html.='<li><a href="'.esc_url($lk).'">'.esc_html($title).'</a></li>'; }
                        } $links_html.='</ul></div>'; }
                    }
                    $content = str_replace(array('{H1}','{CONTENT}','{FEATURE_COLUMNS}','{INTERLINKS}','{CTA_TOP}','{CTA_BOTTOM}'),
                                           array(esc_html($r['h1']), $content, '', $links_html,
                                                 (!empty($r['inject_cta']) and ($r['inject_cta']=='top' or $r['inject_cta']=='both')) ? $cta : '',
                                                 (!empty($r['inject_cta']) and ($r['inject_cta']=='bottom' or $r['inject_cta']=='both')) ? $cta : ''),
                                           $tpl);
                }
                $postarr = array(
                    'post_type'=> $a['post_type'],
                    'post_status'=> !empty($r['status']) ? sanitize_key($r['status']) : $a['status'],
                    'post_title'=> wp_strip_all_tags($r['h1']),
                    'post_content'=> $content,
                    'post_author'=> !empty($r['author']) ? intval($r['author']) : ($a['author']?:get_current_user_id()),
                    'post_parent'=> !empty($r['parent']) ? intval($r['parent']) : $a['parent'],
                );
                if (!empty($r['slug'])) $postarr['post_name'] = sanitize_title($r['slug']);
                $pid=wp_insert_post(wp_slash($postarr), true);
                if(is_wp_error($pid)){ $errors[]=$pid->get_error_message(); continue; }
                $title = !empty($r['meta_title']) ? $r['meta_title'] : ($a['meta_title'] ?: $postarr['post_title']);
                $desc  = !empty($r['meta_desc'])  ? $r['meta_desc']  : ($a['meta_desc'] ?: '');
                if($title || $desc) TCRRB_Meta::apply_seo_meta($pid,$title,$desc);
                if (!empty($r['schema_enable'])){
                    update_post_meta($pid,'tcrrb_schema_enable',1);
                    $sch = array(
                        'name'=>$r['schema_name'] ?? '',
                        'telephone'=>$r['schema_tel'] ?? '',
                        'logo'=>$r['schema_logo'] ?? '',
                        'url'=>get_permalink($pid),
                        'areaServed'=> isset($r['schema_area']) ? array_map('trim', explode(',',$r['schema_area'])) : array(),
                        'address'=> !empty($r['schema_addr']) ? json_decode($r['schema_addr'], true) : array(),
                        'geo'=> !empty($r['schema_geo']) ? json_decode($r['schema_geo'], true) : array(),
                    );
                    update_post_meta($pid,'tcrrb_schema_local',$sch);
                }
                $created++; if ($a['delay']) usleep($a['delay']*1000);
            }
            wp_send_json_success(array('created'=>$created,'errors'=>$errors));
        } else {
            $errors[] = 'Este build v5.2 prioriza Manual Passthrough y Ayuda. Los otros modos funcionan como en v5/v5.1.';
            wp_send_json_success(array('created'=>0,'errors'=>$errors));
        }
    }
    public function ajax_save_preset(){ check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado')); $name=sanitize_text_field($_POST['name'] ?? ''); $data=$_POST['data'] ?? array(); if(!$name||!is_array($data)) wp_send_json_error(array('message'=>'Datos inválidos')); TCRRB_Helpers::save_preset($name,$data); wp_send_json_success(array('message'=>'Plantilla guardada')); }
    public function ajax_load_preset(){ check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado')); $name=sanitize_text_field($_POST['name'] ?? ''); $p=TCRRB_Helpers::get_presets(); if(!$name||empty($p[$name])) wp_send_json_error(array('message'=>'No encontrada')); wp_send_json_success(array('data'=>$p[$name])); }
    public function ajax_enqueue(){ check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado')); $a=$this->collect_args(); $items=array(); $mode=$a['mode_selector']; if($mode==='manual'){ list($headers,$rows)=$this->parse_csv_rows($a['csv']); foreach($rows as $r){ $items[] = array('mode'=>'manual','payload'=>$r,'args'=>$a); } } $n=TCRRB_Queue::enqueue_items($items); wp_send_json_success(array('queued'=>$n)); }
    public function ajax_run_batch(){ check_ajax_referer('tcrrb_nonce','nonce'); if (!current_user_can('manage_options')) wp_send_json_error(array('message'=>'Permiso denegado')); TCRRB_Queue::run_batch(); $q=TCRRB_Helpers::queue_get(); wp_send_json_success(array('remaining'=>count($q))); }
}
new TCRRB_Admin();
